;
; The names for city tiles are not free and must follow the following rules.
; The names consists of 'style name' + '_' + 'index'. The style name is as
; specified in cities.ruleset file and the index only defines the read order
; of the images. The definitions are read starting with index 0 till the first
; missing value The index is checked against the city bonus of effect
; EFT_CITY_IMG and the resulting image is used to draw the city on the tile.
;
; Obviously the first tile must be 'style_name'_city_0 and the sizes must be
; in ascending order. There must also be a 'style_name'_wall_0 tile used to
; draw the wall and an occupied tile to indicate a military units in a city.
; The maximum number of images is only limited by the maximum size of a city
; (currently MAX_CITY_SIZE = 250). The constant is defined in common/city.h.
;

[spec]

; Format and options of this spec file:
options = "+Freeciv-spec-Devel-2013.Feb.13"

[info]

artists = "
    Airfield, city walls and misc stuff Hogne Håskjold <hogne@freeciv.org>
    Modern, Post Modern and Electric Age by Smiley, www.firstcultural.com
    City walls by Hogne Håskjold
    Buoy by Eleazar
    Ruins by Vincent Croisier
"

[file]
gfx = "alio/cities2"

[grid_main]

x_top_left = 1
y_top_left = 1
dx = 96
dy = 72
pixel_border = 1

tiles = { "row", "column", "tag"

; default tiles

; used by all city styles

 0,  0, "city.disorder"
 0,  6, "city.dual_occupied_0"
 0,  6, "city.ocean_occupied_0"

;
; city tiles
;

 1,  0, "city.dual_city_0"
 1,  1, "city.dual_city_1"
 1,  2, "city.dual_city_2"
 1,  3, "city.dual_city_3"
 1,  4, "city.dual_city_4"
 1,  5, "city.dual_wall_0"
 1,  6, "city.dual_wall_1"
 1,  7, "city.dual_wall_2"
 1,  8, "city.dual_wall_3"
 1,  9, "city.dual_wall_4"

 2,  0, "city.ocean_city_0"
 2,  1, "city.ocean_city_1"
 2,  2, "city.ocean_city_2"
 2,  3, "city.ocean_city_3"
 2,  4, "city.ocean_city_4" 
 2,  5, "city.ocean_wall_0"
 2,  6, "city.ocean_wall_1"
 2,  7, "city.ocean_wall_2"
 2,  8, "city.ocean_wall_3"
 2,  9, "city.ocean_wall_4" 

}
