;
; The names for city tiles are not free and must follow the following rules.
; The names consists of 'style name' + '_' + 'index'. The style name is as
; specified in cities.ruleset file and the index only defines the read order
; of the images. The definitions are read starting with index 0 till the first
; missing value The index is checked against the city bonus of effect
; EFT_CITY_IMG and the resulting image is used to draw the city on the tile.
;
; Obviously the first tile must be 'style_name'_city_0 and the sizes must be
; in ascending order. There must also be a 'style_name'_wall_0 tile used to
; draw the wall and an occupied tile to indicate a military units in a city.
; The maximum number of images is only limited by the maximum size of a city
; (currently MAX_CITY_SIZE = 250). The constant is defined in common/city.h.
;

[spec]

; Format and options of this spec file:
options = "+Freeciv-spec-Devel-2013.Feb.13"

[info]

artists = "
    Asian style by CapTVK
    Polynesian style by CapTVK
    Celtic style by Erwan, adapted to 96x48 by CapTVK
    Roman style by CapTVK
    City walls by Hogne Håskjold
"

[file]
gfx = "alio/cities"

[grid_main]

x_top_left = 1
y_top_left = 1
dx = 96
dy = 72
pixel_border = 1

tiles = { "row", "column", "tag"

; used by all city styles

 0,  11, "city.human_occupied_0"

;
; city tiles
;

 0,  0, "city.human_city_0"
 0,  1, "city.human_city_1"
 0,  2, "city.human_city_2"
 0,  3, "city.human_city_3"
 0,  4, "city.human_city_4" 
 0,  5, "city.human_wall_0"
 0,  6, "city.human_wall_1"
 0,  7, "city.human_wall_2"
 0,  8, "city.human_wall_3"
 0,  9, "city.human_wall_4"
}
