/********************************************************
*                                                       *
* (c) 2011-2015 Marko Lindqvist                         *
*                                                       *
* Licensed under Gnu General Public License version 2   *
*                                                       *
********************************************************/

#ifdef HAVE_CONFIG_H
#include <cvc_config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>

#include "cvercmp.h"

int main(int argc, char *argv[])
{
  enum cvercmp_type cmptype;
  bool result;

  if (argc > 1) {
    if (!strcmp(argv[1], "-h") || !strcmp(argv[1], "--help")) {
      printf("Usage: cvercmp <ver1> <compare type> <ver2>\n");
      printf(" <compare type> is one of:\n");
      printf("   - equal\n");
      printf("   - nonequal\n");
      printf("   - lesser\n");
      printf("   - greater\n");
      printf("   - min\n");
      printf("   - max\n");

      return EXIT_SUCCESS;
    } else if (!strcmp(argv[1], "-v") || !strcmp(argv[1], "--version")) {
      printf("cvercmp " PACKAGE_VERSION "\n");

      return EXIT_SUCCESS;
    }
  }

  if (argc != 4) {
    fprintf(stderr, "Wrong number of parameters.\n");
    return EXIT_FAILURE;
  }

  if (!strcasecmp(argv[2], "equal")) {
    cmptype = CVERCMP_EQUAL;
  } else if (!strcasecmp(argv[2], "nonequal")) {
    cmptype = CVERCMP_NONEQUAL;
  } else if (!strcasecmp(argv[2], "greater")) {
    cmptype = CVERCMP_GREATER;
  } else if (!strcasecmp(argv[2], "lesser")) {
    cmptype = CVERCMP_LESSER;
  } else if (!strcasecmp(argv[2], "min")) {
    cmptype = CVERCMP_MIN;
  } else if (!strcasecmp(argv[2], "max")) {
    cmptype = CVERCMP_MAX;
  } else {
    fprintf(stderr, "Unknown comparison type \"%s\"\n", argv[2]);
    return EXIT_FAILURE;
  }

  result = cvercmp(argv[1], argv[3], cmptype);

  if (result) {
    printf("Yes\n");
    return 0;
  } else {
    printf("No\n");
    return 1;
  }
}
