#!/bin/sh

# $1 - File name to create
# $2 - Name of the ai module
template2file() {
  sed "s/<FCAIMODNAME>/$FCAIMODNAME/g" "templates/$1.template" > "$FCAIMDIR/$1"
}

if test "x$1" = "x" || test "x$1" = "x-h" || test "x$1" = "x--help" ; then
  echo "Usage: $(basename $0) <Name of ai module to create>"
  exit
fi

if test "x$1" = "x-v" || test "x$1" = "x--version" ; then
  cat $(dirname $0)/Version
  exit
fi

FCAIMODNAME="$1"
FCAIMDIR="$FCAIMODNAME"

if ! mkdir "$FCAIMDIR" ; then
  echo "Creation of directory \"$FCAIMDIR\" for new ai project failed" >&2
  exit 1
fi

touch "$FCAIMDIR/AUTHORS"
touch "$FCAIMDIR/ChangeLog"
touch "$FCAIMDIR/NEWS"

cp templates/autogen.sh "$FCAIMDIR/"

template2file configure.ac
template2file fcaimod.c
template2file Makefile.am
template2file README

tar cjf "$FCAIMODNAME.tar.bz2" "$FCAIMDIR"
